unit EngineImgService01;
(*
   ========================================================================
    " " GraphEngine.
       .
   : BitMap.PixelFormat = pf24bit
   ========================================================================
     :
   1)  DitMap      .
   2)      .
   ========================================================================
   ()  ,    , , .
   ========================================================================
*)

interface

uses
  //  
  Windows, Messages, StrUtils, SysUtils, Classes, Types, Graphics, jpeg,
  Controls, Dialogs, ComCtrls, ExtCtrls,
  //  GraphEngine
  EngineMainData01,
  //  
  MainData;

// ========================================================================
//    
// ========================================================================
//       
function TextToInt (Text : string; var Digit : integer): boolean;

// ========================================================================
//   ( ) BitMap   .
// ========================================================================
//   BitMap
procedure MimimizeBitMap (RqBitMap : TBitMap);

// ========================================================================
//       BGR-  BitMap   .
//   BitMap      
//      .
// ========================================================================
//  BitMap  BGR- 
procedure BitMapToImgTab(RqBitmap    : TBitmap;
                         ptITabBGR   : ptImgTabBGR;
                         RqProgress  : TProgressBar);
// ------------------------------------------------------------------------
//    3.5
//   Rectangle    BitMap
//     ImgTabColor
procedure AreaBitMapToImgTabColor
                      (RqBitMap      : TBitMap;        //  DitMap
                       RqRec         : TRect;          //  
                       ptTargetArray : ptImgTabColor   // ImgTabColor 
                       );
// ------------------------------------------------------------------------
//  ImgTabColor  TrgBitMap    RqPnt
//   : (RqPnt.X >= 0)  (RqPnt.Y >= 0)
procedure PasteImgTabColorToBitMap
                      (ptSrcArray : ptImgTabColor;  //  ImgTabColor
                       RqPnt         : TPoint;      //  
                       TrgBitMap      : TBitMap     // BitMap 
                       );
// ------------------------------------------------------------------------
//    3.5
//  BitMap    (RqRec)   BitMap
function AreaBitMapToBitMap
            (SrcBitMap   : TBitMap;             //  BitMap
             RqRec       : TRect ) : TBitMap;   // BitMap 
// ------------------------------------------------------------------------
//    3.5
//  SrcBitMap  TrgBitMap    RqPnt
//   : (RqPnt.X >= 0)  (RqPnt.Y >= 0)
procedure PasteBitMapToBitMap
            (SrcBitMap   : TBitMap;    //  DitMap
             RqPnt       : TPoint;     //   
             TrgBitMap   : TBitMap);   // BitMap 
// ------------------------------------------------------------------------
//  BitMap  Image  BGR- 
procedure ImageToImgTab (RqImage     : TImage;
                         ptITabBGR   : ptImgTabBGR;
                         RqProgress  : TProgressBar);
// ------------------------------------------------------------------------
//  BGR-   BitMap
procedure ImgTabToBitMap(RqBitMap    : TBitMap;
                         ptITabBGR   : ptImgTabBGR;
                         RqProgress  : TProgressBar);
// ------------------------------------------------------------------------
//     Image (  SHOW)
//  BGR-   Image
procedure ImgTabToImage (ptITabBGR   : ptImgTabBGR;
                         RqImage     : TImage;
                         RqProgress  : TProgressBar);

// ========================================================================
//      ImgTabBGR  ImgTabColor .
//        .
// ========================================================================
//    TImgTabBGR    TImgTabBGR
procedure TabBGRtoTabBGR (ptSourceArray : ptImgTabBGR;
                          ptTargetArray : ptImgTabBGR);
// ------------------------------------------------------------------------
//    TImgTabColor    TImgTabColor
procedure TabColorToTabColor (ptSourceArray : ptImgTabColor;
                              ptTargetArray : ptImgTabColor);

// ========================================================================
//     ImgTabBGR  TImgTabColor .
//          
//   .
// ========================================================================
//    TImgTabBGR    TImgTabColor
procedure TabBRGtoTabColor (ptSourceArray : ptImgTabBGR;
                            ptTargetArray : ptImgTabColor);
// ------------------------------------------------------------------------
//    TImgTabColor    TImgTabBGR
procedure TabColorToTabBRG (ptSourceArray : ptImgTabColor;
                            ptTargetArray : ptImgTabBGR);
                            
// ========================================================================
//         .
//        
//         
// .
// ========================================================================
//      Rectangle    ImgTabBGR
//     ImgTabBGR
procedure SelectedToImgTab
                      (ptSourceArray : ptImgTabBGR;  //  ImgTab
                       RqRec         : TRect;        //  
                       ptTargetArray : ptImgTabBGR   // ImgTab 
                       );
// ------------------------------------------------------------------------
//      Rectangle    ImgTabBGR
//     ImgTabColor
procedure SelectedToImgTabColor
                      (ptSourceArray  : ptImgTabBGR;  //  ImgTab
                       RqRec        : TRect;          //  
                       ptTargetArray : ptImgTabColor  // ImgTabColor 
                       );
// ------------------------------------------------------------------------
//      *.TXT
function TxtToImgTabBGR (ptITabBGR  : ptImgTabBGR;
                         RqSep      : string;
                         RqFileName : string;
                         RqProgress : TProgressBar) : boolean;
// ------------------------------------------------------------------------
//      *.TXT
procedure ImgTabExportToTxt(ptITabBGR   : ptImgTabBGR;
                            RqSeparator : string;
                            FileName    : string;
                            RqProgress  : TProgressBar);
// ------------------------------------------------------------------------
//  Image  
procedure ClearImage (RqImg : TImage; RqColor : TColor);

// ------------------------------------------------------------------------
//  SrcBitmap  TrgBitMap  
procedure BitMapToGrayBitMap(SrcBitmap : TBitmap;
                             TrgBitMap : TBitmap);

// ========================================================================
// ========================================================================
implementation
// ========================================================================
// ========================================================================

//       ( !)
const cBPP  = 3;  // BytePerPixel ( : BitMap.PixelFormat = pf24bit)

// ========================================================================
//    
// ========================================================================
// 26.10.2008
//       
function TextToInt (Text : string; var Digit : integer): boolean;
begin
  Result := False;
  if Trim(Text) <> ''
  then begin
    try
      Digit := StrToInt(Trim(Text));
      Result := True;
    except
      Digit := 0;
    end;
  end
  else begin
    Digit  := 0;
    Result := True;
  end;
end; // of function

// ========================================================================
//   ( ) BitMap   .
// ========================================================================
// 30.01.2013
//   BitMap
procedure MimimizeBitMap (RqBitMap : TBitMap);
const MinSize = 2;
begin
  //  
  if Assigned(RqBitmap)
  then begin
     RqBitMap.Height := MinSize;
     RqBitMap.Width  := MinSize;
  end;
end;

// ========================================================================
//       BGR-  BitMap   .
//   BitMap      
//      .
// ========================================================================
// 23.04.2014 (     Move)
//  BitMap  BGR- 
procedure BitMapToImgTab(RqBitmap   : TBitmap;
                         ptITabBGR  : ptImgTabBGR;
                         RqProgress : TProgressBar);
var   Row  : word;              //     BitMap
      PtAB : PtArrayByte;       //     BitMap
begin
  //  
  if Assigned(RqBitmap) and Assigned(ptITabBGR)
  then begin
     //  
     if (RqBitmap.Width  > 0) and
        (RqBitmap.Height > 0) and
        (RqBitmap.PixelFormat = pf24bit)
     then begin
       //   
       RqProgress.Position := 0;
       RqProgress.Max := RqBitmap.Height - 1;
       try
          //        ptITabBGR^
          SetLength(ptITabBGR^, RqBitmap.Height);
          //    RqBitmap
          for Row := 0 to RqBitmap.Height - 1 do
          begin
            //      
            SetLength(ptITabBGR^[Row], cBPP * RqBitmap.Width);
            //       Bitmap
            PtAB := RqBitmap.ScanLine[Row];
            // Move(const Source; var Dest; Count: Integer);
            Move(PtAB^[0], ptITabBGR^[Row, 0], cBPP * RqBitmap.Width);
            //   
            RqProgress.Position := Row;
          end;
       except
          SetLength(ptITabBGR^, 0);
          MessageDlg('BitMapToImgTab :    BitMap  BGR-.',
                      mtWarning,
                      [mbOk], 0);
       end;
       //  
       RqProgress.Position := 0;
     end;
  end;  // of Assigned
end;  // of procedure
// ------------------------------------------------------------------------
// 23.04.2014 (     Move)
//  BGR-   BitMap
procedure ImgTabToBitMap(RqBitMap    : TBitMap;
                         ptITabBGR   : ptImgTabBGR;
                         RqProgress  : TProgressBar);
var Row  : word;         //     BitMap
    PtAB : PtArrayByte;  //     BitMap
begin
  //  
  if Assigned(RqBitMap) and Assigned(ptITabBGR^)
  then begin
    //  
    if (RqBitmap.PixelFormat = pf24bit) and (Length(ptITabBGR^) > 0)
    then begin
      //   
      RqProgress.Position := 0;
      RqProgress.Max := Length(ptITabBGR^) - 1;
      try
         //   BitMap
         RqBitmap.Height := Length(ptITabBGR^);
         RqBitmap.Width  := Length(ptITabBGR^[0]) div cBPP;
         if (RqBitmap.Height > 0) and (RqBitmap.Width > 0)
         then begin
            //     
            for Row := 0 to Length(ptITabBGR^) - 1 do
            begin
              if Length(ptITabBGR^[Row]) > 0
              then begin
                 //      Bitmap
                 PtAB := RqBitmap.ScanLine[Row];
                 // Move(const Source; var Dest; Count: Integer);
                 Move(ptITabBGR^[Row, 0], PtAB^[0], cBPP * RqBitmap.Width);
              end;
              //   
              RqProgress.Position := Row;
            end;
         end;
      except
          MessageDlg('ImgTabToBitMap :    BGR-  BitMap.',
                      mtWarning,
                      [mbOk], 0);
      end;
      //  
      RqProgress.Position := 0;
    end; // of RqBitmap.PixelFormat = pf24bit
  end; // of Assigned
end;  // of procedure

// ------------------------------------------------------------------------
// 25.01.2013
//  BitMap  Image  BGR- 
procedure ImageToImgTab (RqImage     : TImage;
                         ptITabBGR   : ptImgTabBGR;
                         RqProgress  : TProgressBar);
begin
  with RqImage.Picture do
  begin
    //  
    if Bitmap.PixelFormat = pf24bit
    then
       //  
       if (Bitmap.Width  > 0) and (Bitmap.Height > 0)
       then BitMapToImgTab(Bitmap, ptITabBGR, RqProgress);
  end; // of  with
end;  // of procedure
// ------------------------------------------------------------------------
// 29.01.2013
//     Image (  SHOW)
//  BGR-   Image
procedure ImgTabToImage (ptITabBGR  : ptImgTabBGR;
                         RqImage    : TImage;
                         RqProgress : TProgressBar);
var WBitmap   : TBitMap;
begin
   WBitmap := nil;       // 
   try
     //   BitMap
     WBitmap := TBitmap.Create;
     //  -  
     WBitmap.HandleType  := bmDIB;
     //    
     WBitmap.PixelFormat := pf24bit;
     //---------------------------------
     //  WBitmap 
     ImgTabToBitMap(WBitmap, ptITabBGR, RqProgress);
     //    Image
     RqImage.Picture.Bitmap.Assign(WBitmap);
     //---------------------------------
   finally
    //   Bitmap
    if Assigned(WBitmap) then WBitmap.Free;
   end;
end;  // of procedure

// ========================================================================
//      ImgTabBGR  ImgTabColor .
//        .
// ========================================================================
// 23.04.2014 (     Move)
//    TImgTabBGR    TImgTabBGR
procedure TabBGRtoTabBGR (ptSourceArray : ptImgTabBGR;
                          ptTargetArray : ptImgTabBGR);
var SRow : word;
begin
   //  
   if Assigned(ptSourceArray) and Assigned(ptTargetArray)
   then begin
      //  
      if  Length(ptSourceArray^) > 0
      then begin
         try
           //    
           SetLength(ptTargetArray^, Length(ptSourceArray^));
           for SRow := 0 to High(ptSourceArray^) do
           begin
             //       
             SetLength(ptTargetArray^[SRow], Length(ptSourceArray^[SRow]));
             // Move(const Source; var Dest; Count: Integer);
             Move(ptSourceArray^[SRow, 0],
                  ptTargetArray^[SRow, 0],
                  Length(ptSourceArray^[SRow]));
           end;
         except
            SetLength(ptTargetArray^, 0);
            MessageDlg('TabBRGtoTabBGR :    .',
                        mtWarning,
                       [mbOk], 0);
         end;
      end;
   end;
end;
// ------------------------------------------------------------------------
// 23.04.2014 (     Move)
//    TImgTabColor    TImgTabColor
procedure TabColorToTabColor (ptSourceArray : ptImgTabColor;
                              ptTargetArray : ptImgTabColor);
var SRow : word;
begin
   //  
   if Assigned(ptSourceArray) and Assigned(ptTargetArray)
   then begin
      //  
      if Length(ptSourceArray^) > 0
      then begin
         try
           //    
           SetLength(ptTargetArray^, Length(ptSourceArray^));
           for SRow := 0 to High(ptSourceArray^) do
           begin
              //       
              SetLength(ptTargetArray^[SRow], Length(ptSourceArray^[SRow]));
              // Move(const Source; var Dest; Count: Integer);
              Move(ptSourceArray^[SRow, 0],
                   ptTargetArray^[SRow, 0],
                   Length(ptSourceArray^[SRow]));
           end;
         except
            SetLength(ptTargetArray^, 0);
            MessageDlg('TabColorToTabColor :    .',
                       mtWarning,
                      [mbOk], 0);
         end;
      end;
   end;
end;

// ========================================================================
//     ImgTabBGR  TImgTabColor .
//          
//   .
// ========================================================================
// 27.01.2013
//    TImgTabBGR    TImgTabColor
procedure TabBRGtoTabColor (ptSourceArray : ptImgTabBGR;
                            ptTargetArray : ptImgTabColor);
var SRow, SCol : word;
    TCol, WCol : word;
begin
  //  
  if Assigned(ptSourceArray) and Assigned(ptTargetArray)
  then begin
    //  
    if Length(ptSourceArray^) > 0
    then begin
       try
         //    
         SetLength(ptTargetArray^, Length(ptSourceArray^));
         for SRow := Low(ptSourceArray^) to High(ptSourceArray^) do
         begin
           //     
           TCol := Length(ptSourceArray^[SRow]) div cBPP;
           //       
           SetLength(ptTargetArray^[SRow], TCol);
           SCol := 0;
           WCol := 0;
           repeat
             //     
             ptTargetArray^[SRow, WCol].B := ptSourceArray^[SRow, SCol];
             ptTargetArray^[SRow, WCol].G := ptSourceArray^[SRow, SCol + 1];
             ptTargetArray^[SRow, WCol].R := ptSourceArray^[SRow, SCol + 2];
             Inc(WCol);             // TCol + 1;
             Inc(SCol, cBPP);       // SCol + 3;
           until WCol >= TCol;
         end;
       except
         SetLength(ptTargetArray^, 0);
         MessageDlg('TabBRGtoTabColor :    .',
                     mtWarning,
                    [mbOk], 0);
       end;
    end;
  end;
end;
// ------------------------------------------------------------------------
// 27.01.2013
//    TImgTabColor    TImgTabBGR
procedure TabColorToTabBRG (ptSourceArray : ptImgTabColor;
                            ptTargetArray : ptImgTabBGR);
var SRow, SCol : word;
    TCol, WCol : word;
begin
  //  
  if Assigned(ptSourceArray) and Assigned(ptTargetArray)
  then begin
     //  
     if Length(ptSourceArray^) > 0
     then begin
       try
          //    
          SetLength(ptTargetArray^, Length(ptSourceArray^));
          for SRow := Low(ptSourceArray^) to High(ptSourceArray^) do
          begin
            //    
            TCol := Length(ptSourceArray^[SRow]) * cBPP;
            //       
            SetLength(ptTargetArray^[SRow], TCol);
            SCol := 0;
            WCol := 0;
            repeat
              //     
              ptTargetArray^[SRow, SCol] := ptSourceArray^[SRow, WCol].B;
              ptTargetArray^[SRow, SCol + 1] := ptSourceArray^[SRow, WCol].G;
              ptTargetArray^[SRow, SCol + 2] := ptSourceArray^[SRow, WCol].R;
              Inc(WCol);              // TCol + 1;
              Inc(SCol, cBPP);        // SCol + 3;
            until SCol >= TCol;
          end;
       except
          SetLength(ptTargetArray^, 0);
          MessageDlg('TabColorToTabBRG :    .',
                     mtWarning,
                     [mbOk], 0);
       end;
    end;
  end;
end;

// ========================================================================
//         .
//        
//         
// .
// ========================================================================
// 27.01.2013
//      Rectangle    ImgTabBGR
//     ImgTabBGR
procedure SelectedToImgTab
                      (ptSourceArray : ptImgTabBGR;  //  ImgTab
                       RqRec         : TRect;        //  
                       ptTargetArray : ptImgTabBGR   // ImgTab 
                       );
var  ImgTabRect : TRect;     //  ptSourceArray^   
     CrRect     : TRect;     //    RqRec
     RowB, RowE : integer;   // SourceArray   
     ColB, ColE : integer;   // SourceArray   
     SRow, DRow : integer;   //     ptSourceArray^
     SCol, DCol : integer;   //     ptTargetArray^
begin
   //  
  if (not Assigned(ptSourceArray)) or (not Assigned(ptTargetArray))
  then Exit;
  //   1
  if not (Length(ptSourceArray^) > 0)
  then Exit;
  //   2 (  RqRec)
  if not ((RqRec.Right >= RqRec.Left) and (RqRec.Bottom >= RqRec.Top))
  then Exit;
  //    ImgTabSrc   Rectangle
  ImgTabRect := Rect(0, 0,
                     (Length(ptSourceArray^[0]) div cBPP) - 1,   // MaxCol
                      Length(ptSourceArray^) -1 );               // MaxRow
  //       ImgTab
  if CrossRect(CrRect, ImgTabRect, RqRec)
  then begin
    //        ptSourceArray^
    with CrRect do
    begin
        RowB := Top;
        RowE := Bottom;
        ColB := Left * cBPP;
        ColE := Right  * cBPP + (cBPP -1);
    end;
    //  
    try
       //    TargetArray
       DRow := 0;
       //   
       SetLength(ptTargetArray^, RowE - RowB + 1);
       for SRow := RowB to RowE do
       begin
          //       TargetArray
          DCol := 0;
          //      
          SetLength(ptTargetArray^[DRow], ColE - ColB + 1);
          for SCol := ColB to ColE do
          begin
            ptTargetArray^[DRow, DCol] := ptSourceArray^[SRow, SCol];
            Inc(DCol);
          end;
          Inc(DRow);
       end;
    except
        SetLength(ptTargetArray^, 0); //  
        MessageDlg('SelectedToImgTab :      .',
                  mtWarning,
                  [mbOk], 0);
    end;
  end;
end;
// ------------------------------------------------------------------------
// 28.01.2013
//      Rectangle    ImgTabBGR
//     ImgTabColor
procedure SelectedToImgTabColor
                      (ptSourceArray  : ptImgTabBGR;  //  ImgTab
                       RqRec        : TRect;          //  
                       ptTargetArray : ptImgTabColor  // ImgTabColor 
                       );
var  ImgTabRect : TRect;     //  ptSourceArray^   
     CrRect     : TRect;     //    RqRec
     RowB, RowE : integer;   // SourceArray   
     ColB, ColE : integer;   // SourceArray   
     SRow, SCol : integer;   //     ptSourceArray^
     DRow, DCol : integer;   //     ptTargetArray^
begin
   //  
  if (not Assigned(ptSourceArray)) or (not Assigned(ptTargetArray))
  then Exit;
  //   1
  if not (Length(ptSourceArray^) > 0)
  then Exit;
  //   2 (  RqRec)
  if not ((RqRec.Right >= RqRec.Left) and (RqRec.Bottom >= RqRec.Top))
  then Exit;
  //    ImgTabSrc   Rectangle
  ImgTabRect := Rect(0, 0,
                     (Length(ptSourceArray^[0]) div cBPP) - 1,   // MaxCol
                      Length(ptSourceArray^) -1 );               // MaxRow
  //       ImgTab
  if CrossRect(CrRect, ImgTabRect, RqRec)
  then begin
    //        SourceArray
    with CrRect do
    begin
        RowB := Top;
        RowE := Bottom;
        ColB := Left * cBPP;
        ColE := Right  * cBPP + (cBPP -1);
    end;
    //  
    try

       DRow := 0;  //      TargetArray
       //      TargetArray
       SetLength(ptTargetArray^, RowE - RowB + 1);
       for SRow := RowB to RowE do
       begin
         //      
         SetLength(ptTargetArray^[DRow], (ColE - ColB + 1) div cBPP);
         SCol := ColB; // -     SourceArray
         DCol := 0;    // -     TargetArray
         repeat
            ptTargetArray^[DRow, DCol].B := ptSourceArray^[SRow, SCol];
            ptTargetArray^[DRow, DCol].G := ptSourceArray^[SRow, SCol + 1];
            ptTargetArray^[DRow, DCol].R := ptSourceArray^[SRow, SCol + 2];
            Inc(DCol);
            Inc(SCol, cBPP);
        until (SCol >= ColE);
        Inc(DRow);
       end;
    except
        SetLength(ptTargetArray^, 0); //  
        MessageDlg('SelectedToImgTabColor : '
                 + '     .',
                  mtWarning,
                  [mbOk], 0);
    end;
  end;
end;

// ========================================================================
//  /    /  txt - 
// ========================================================================
// 26.10.2008
//       
//    
function ImportTextToInt (Text : string; var Digit : byte): boolean;
begin
  try
    Digit := StrToInt(Text);
    Result := True;
  except
    Digit := 0;
    Result := False;
  end;
end; // of function
// ------------------------------------------------------------------------
// 28.10.2008.
//      *.TXT
function TxtToImgTabBGR (ptITabBGR  : ptImgTabBGR;
                         RqSep      : string;
                         RqFileName : string;
                         RqProgress : TProgressBar) : boolean;
var
  //   
  TempList : TStringList;
var
  MaxRow       : word;     //     ptITabBGR^
  Row          : word;     //    ptITabBGR^
  WStr         : string;   //  
  Ind, SepPos  : integer;  //     
  Count        : word;     //      ptITabBGR^
  SkipCount    : word;     //     
  WTab         : array of byte;  //    ptITabBGR^
begin
  //   
  Result := False;
  //  
  if not Assigned(ptITabBGR) then Exit;
  // ----------------------------------
  SkipCount := 0;
  TempList := nil;
  try
    TempList := TStringList.Create;	{     }
    TempList.Delimiter := #0;
    TempList.QuoteChar := #0;
    TempList.CommaText := '';
    TempList.LoadFromFile(RqFileName);
    // ----------------------------------
    //    
    //     TempList
    MaxRow  := TempList.Count;
    if MaxRow > 0   //   
    then begin
       RqProgress.Position := 0;
       RqProgress.Max := MaxRow;
       //     ptITabBGR^
       SetLength(ptITabBGR^, MaxRow);
       for Row := 0 to MaxRow - 1 do
       begin
         //       
         //        ptITabBGR^[Row]
         WStr := Trim(TempList.Strings[Row]);
         // ----------------------------------------
         //    
         // WTab     .
         SetLength(WTab,(Length(WStr) div 2));
         //     
         Count := 0;
         while Length(WStr) > 0
         do begin
            //   
            // (Pos = 0      = 1
            //        )
            SepPos := Pos(RqSep, WStr);
            if SepPos <> 0
            then begin
               //      (Copy)
               //     
               if ImportTextToInt(Copy(WStr, 0, SepPos-1), WTab[Count])
               then Inc(Count)
               else Inc(SkipCount);
               //    
               Delete(WStr, 1, SepPos);
            end else WStr := '';
         end; // of Length(WStrXY) > 0
         // ----------------------------------------
         if Count > 0
         then begin
            //     ptITabBGR^[Row]
            SetLength(ptITabBGR^[Row], Count);
            for Ind := 0 to Count - 1 do
            begin
               ptITabBGR^[Row,Ind]:= WTab[Ind];
            end;
         end;
         RqProgress.Position := Row;
       end; // of for Row
    end; // of MaxRow
    //    ,   
    if SkipCount = 0 then Result := True;
  // ----------------------------------------
  finally
    //     
    if Assigned(TempList) then TempList.Free;
  end;
  // ----------------------------------------
  RqProgress.Position := 0;
end; {of procedure}

// ------------------------------------------------------------------------
// 28.10.2008
//      *.TXT
procedure ImgTabExportToTxt(ptITabBGR   : ptImgTabBGR;
                            RqSeparator : string;
                            FileName    : string;
                            RqProgress  : TProgressBar);
var Row, Col   : word;
    StrList    : TStringList;
    WStr       : string;
begin
  //  
  if Assigned(ptITabBGR^)
  then begin
    StrList := nil;
    try
      StrList := TStringList.Create;
      //   
      RqProgress.Position := 0;
      RqProgress.Max := Length(ptITabBGR^) - 1;
      //     ptITabBGR^
      for Row := 0 to (Length(ptITabBGR^) - 1) do
      begin
        WStr := '';
        for Col := 0 to Length(ptITabBGR^[Row]) - 1 do
        begin
          WStr := WStr + IntToStr(ptITabBGR^[Row, Col]) + RqSeparator;
        end;
        StrList.Add(WStr);
        //   
        RqProgress.Position := Row;
      end;
      StrList.SaveToFile(FileName);
      //  
      RqProgress.Position := 0;
    finally
       if Assigned(StrList) then StrList.Free;
    end; // of try
  end; // of Assigned
end; // of procedure

// ========================================================================
//
//        3.5
//
// ========================================================================
// 31.03.2014  ()
//   Rectangle    BitMap
//     ImgTabColor
procedure AreaBitMapToImgTabColor
                      (RqBitMap      : TBitMap;        //  BitMap
                       RqRec         : TRect;          //  
                       ptTargetArray : ptImgTabColor   // ImgTabColor 
                       );
var  SrcRect  : TRect;         //  BitMap   
     WRqRect  : TRect;         //   RqRec
     CrsRect  : TRect;         //   SrcRect  WRqRect
     SRowB, SRowE : integer;   // BitMap   
     SColB, SColE : integer;
     PtS      : PtArrayByte;   //    
     TRowB, TRowE : integer;
     TColB, TColE : integer;   // BitMap   
     SRow, SCol : integer;     //     BitMap
     TRow, TCol : integer;     //     ptTargetArray^
begin
   //  
  if (not Assigned(RqBitMap)) or (not Assigned(ptTargetArray))
  then Exit;
  //    1
  if (RqBitMap.Empty) or
     (RqBitMap.PixelFormat <> pf24bit)
  then Exit;
   //   RqRec
  WRqRect := NoarmalRect(RqRec.TopLeft, RqRec.BottomRight);
  //   RqRec  SrcBitMap
  WRqRect := CutRecToBitMap (RqBitMap, WRqRect);
  //    SrcBitMap   Rectangle
  SrcRect := Rect(0, 0, RqBitMap.Width - 1, RqBitMap.Height -1 );

  //  CrRect     BitMap
  if CrossRect(CrsRect, SrcRect, WRqRect)
  then begin
    //    
    //       BitMap
    with CrsRect do
    begin
        SRowB := Top;             //     SrcBitMap
        SRowE := Bottom;          //     SrcBitMap
        SColB := Left  * cBPP;    //      SrcBitMap
        SColE := Right * cBPP;    //      SrcBitMap
        // -----------------------
        TRowB := 0;               //     ptTargetArray^
        TRowE := Bottom - Top;    //      ptTargetArray^
        TColB := 0;               //     ptTargetArray^
        TColE := Right - Left;    //     ptTargetArray^
    end;
    try
       //  
       //      TargetArray
       SetLength(ptTargetArray^, TRowE - TRowB + 1);
       TRow := TRowB;  //      TargetArray
       for SRow := SRowB to SRowE do
       begin
         //      
         SetLength(ptTargetArray^[TRow], (TColE - TColB + 1));
         //       Bitmap
         PtS  := RqBitmap.ScanLine[SRow];
         SCol := SColB;
         TCol := TColB;
         repeat
            ptTargetArray^[TRow, TCol].B := PtS^[SCol];
            ptTargetArray^[TRow, TCol].G := PtS^[SCol + 1];
            ptTargetArray^[TRow, TCol].R := PtS^[SCol + 2];
            Inc(TCol);           //     TargetArray
            Inc(SCol, cBPP);     //     BitMap
        until (SCol > SColE);
        Inc(TRow);
       end;
    except
        SetLength(ptTargetArray^, 0);            //  
        MessageDlg('AreaBitMapToImgTabColor : '
                 + '     .',
                  mtWarning,
                  [mbOk], 0);
    end;
  end;
end;

// ------------------------------------------------------------------------
// 31.03.2014 ()
//  ImgTabColor  TrgBitMap    RqPnt
//   : (RqPnt.X >= 0)  (RqPnt.Y >= 0)
procedure PasteImgTabColorToBitMap
                      (ptSrcArray : ptImgTabColor;  //  ImgTabColor
                       RqPnt         : TPoint;      //  
                       TrgBitMap      : TBitMap     // BitMap 
                       );
var  SrcRect : TRect;        // SrcBitMap   
     TrgRect : TRect;        // TrgBitMap    
     CrsRect : TRect;        //  
     // ---------------------
     SColB   : integer;      //      ptSrcArray^
     SColE   : integer;      //      ptSrcArray^
     // ---------------------
     TRowB   : integer;      //      TrgBitMap
     TRowE   : integer;      //      TrgBitMap
     TColB   : integer;      //      TrgBitMap
     // ---------------------
     SRow    : integer;      //      ptSrcArray^
     SCol    : integer;      //      ptSrcArray^
     // ---------------------
     TRow    : integer;      //     TrgBitMap
     TCol    : integer;      //     TrgBitMap
     PtT     : PByteArray;   //      TrgBitMap
     // ---------------------
begin
   //  
  if (not Assigned(TrgBitMap)) or (not Assigned(ptSrcArray))
  then Exit;
  //  
  if (RqPnt.X < 0) or (RqPnt.Y < 0) or
     (Low(ptSrcArray^) <> 0) or (Low(ptSrcArray^[0]) <> 0)
  then Exit;
  //    1
  if (Length(ptSrcArray^) = 0) or
     (TrgBitMap.Empty) or
     (TrgBitMap.PixelFormat <> pf24bit)
  then Exit;

  //    
  SrcRect := Rect(RqPnt.X, RqPnt.Y,
                  RqPnt.X + High(ptSrcArray^[0]),
                  RqPnt.Y + High(ptSrcArray^));
  //  BitMap,  
  TrgRect := Rect(0, 0, TrgBitMap.Width-1, TrgBitMap.Height-1);

  //  CrsRect     BitMap
  if CrossRect(CrsRect, SrcRect, TrgRect)
  then begin //    
    //  
    CrsRect := NoarmalRect(CrsRect.TopLeft, CrsRect.BottomRight);
    //        TrgBitMap
    with CrsRect do
    begin
       TRowB := Top;           //      TrgBitMap
       TRowE := Bottom;        //      TrgBitMap
       TColB := Left  * cBPP;  //      TrgBitMap
       // ---------------------
       SColB := Left;          //      ptSrcArray^
       SColE := Right;         //      ptSrcArray^
    end;
    try
       //  
       //     ptSrcArray^
       SRow := 0;
       for TRow := TRowB to TRowE do
       begin
          //       Bitmap
          PtT  := TrgBitMap.ScanLine[TRow];
          //     Bitmap
          TCol := TColB;
          //     ptSrcArray^
          SCol := 0;
          repeat
             PtT^[TCol]      := ptSrcArray^[SRow, SCol].B;
             PtT^[TCol + 1]  := ptSrcArray^[SRow, SCol].G;
             PtT^[TCol + 2]  := ptSrcArray^[SRow, SCol].R;
             Inc(SCol);         //     ptSrcArray^
             Inc(TCol, cBPP);   //     BitMap
          until (SCol > (SColE - SColB));
          Inc(SRow);            //     ptSrcArray^
       end;
    except
        MessageDlg('SelectedToImgTabColor : '
                 + '     .',
                  mtWarning, [mbOk], 0);
    end;
  end;
end;

// ------------------------------------------------------------------------
// 29.03.2014  ()
//  BitMap    (RqRec)   BitMap
function AreaBitMapToBitMap
            (SrcBitMap   : TBitMap;             //  DitMap
             RqRec       : TRect ) : TBitMap;   // BitMap 

var  SrcRect  : TRect;        //  BitMap   
     WRqRect  : TRect;        //   RqRec
     CrsRect  : TRect;        //   SrcRect  WRqRect
     SRowB    : integer;      //     SrcBitMap
     SRowE    : integer;      //     SrcBitMap
     SColB    : integer;      //     SrcBitMap
     CCount  : integer;       //    
     PtS      : PtArrayByte;  //      SrcBitMap
     PtT      : PByteArray;   //      Result
     SRow     : integer;      //     SrcBitMap
     TRow     : integer;      //     Result
begin
  Result := NIL;              //  
  //  
  if not Assigned(SrcBitMap) then Exit;
  //    1
  if (SrcBitMap.Empty) or
     (SrcBitMap.PixelFormat <> pf24bit)
  then Exit;

  //   RqRec
  WRqRect := NoarmalRect(RqRec.TopLeft, RqRec.BottomRight);
  //   RqRec  SrcBitMap
  WRqRect := CutRecToBitMap (SrcBitMap, WRqRect);
  //    SrcBitMap   Rectangle
  SrcRect := Rect(0, 0, SrcBitMap.Width - 1, SrcBitMap.Height -1 );

  //  CrRect     BitMap
  if CrossRect(CrsRect, SrcRect, WRqRect)
  then begin //    
    //        Result
    with CrsRect do
    begin
        SRowB := Top;                //     SrcBitMap
        SRowE := Bottom;             //     SrcBitMap
        SColB  := Left * cBPP;       //     SrcBitMap
        CCount := (Right - Left + 1) * cBPP;  //    
    end;
    try
       //  Result BitMap
       Result := TBitMap.Create;
       Result.PixelFormat := pf24bit;
       Result.Height := CrsRect.Bottom - CrsRect.Top  + 1;
       Result.Width  := CrsRect.Right  - CrsRect.Left + 1;
       //  
       TRow := 0;  //      Result
       for SRow := SRowB to SRowE do
       begin
         //       SrcBitMap
         PtS := SrcBitMap.ScanLine[SRow];
         PtS := Addr(PtS^[SColB]);
         //       Result
         PtT := Result.ScanLine[TRow];
         PtT := Addr(PtT^[0]);
         // Move(const Source; var Dest; Count: Integer);
         Move(PtS^,  PtT^,  CCount);
         Inc(TRow);
       end;
    except
        if Assigned(Result)
        then begin
           Result.Free;
           Result := NIL;
        end;
        MessageDlg('AreaBitMapToBitMap : '
                 + '     BitMap.',
                  mtWarning,
                  [mbOk], 0);
    end;
  end;
end;

// ------------------------------------------------------------------------
// 29.03.2014 ()
//  SrcBitMap  TrgBitMap    RqPnt
//   : (RqPnt.X >= 0)  (RqPnt.Y >= 0)
procedure PasteBitMapToBitMap
            (SrcBitMap   : TBitMap;    //  DitMap
             RqPnt       : TPoint;     //   
             TrgBitMap   : TBitMap);   // BitMap 

var  SrcRect : TRect;        // SrcBitMap   
     TrgRect : TRect;        // TrgBitMap    
     CrsRect : TRect;        //  
     TRowB   : integer;      //      TrgBitMap
     TRowE   : integer;      //      TrgBitMap
     TColB   : integer;      //      TrgBitMap
     CCount  : integer;      //   
     PtS     : PtArrayByte;  //      SrcBitMap
     PtT     : PByteArray;   //      Result
     TRow    : integer;      //     TrgBitMap
     SRow    : integer;      //     SrcBitMap

begin
  //  
  if (not Assigned(SrcBitMap)) or (not Assigned(TrgBitMap)) then Exit;
  //  
  if (RqPnt.X < 0) or (RqPnt.Y < 0) then Exit;
  //   1
  if (SrcBitMap.Empty) or
     (TrgBitMap.Empty) or
     (SrcBitMap.PixelFormat <> pf24bit) or
     (TrgBitMap.PixelFormat <> pf24bit)
  then Exit;

  //    SrcBitMap  TrgBitMap
  SrcRect := Rect(RqPnt.X, RqPnt.Y,
                  RqPnt.X + SrcBitMap.Width-1,
                  RqPnt.Y + SrcBitMap.Height-1);
  TrgRect := Rect(0, 0, TrgBitMap.Width-1, TrgBitMap.Height-1);

  //  CrsRect     BitMap
  if CrossRect(CrsRect, TrgRect, SrcRect)
  then begin //    
    //  
    CrsRect := NoarmalRect(CrsRect.TopLeft, CrsRect.BottomRight);
    //        TrgBitMap
    with CrsRect do
    begin
        TRowB  := Top;                        //    
        TRowE  := Bottom;                     //    
        TColB  := Left * cBPP;                //    
        CCount := (Right - Left + 1) * cBPP;  //   
    end;
    try
       //  
       SRow := 0;  //      Result
       for TRow := TRowB to TRowE do
       begin
         //         TrgBitMap
         PtT := TrgBitMap.ScanLine[TRow];
         PtT := Addr(PtT^[TColB]);
         //         SrcBitMap
         PtS := SrcBitMap.ScanLine[SRow];
         PtS := Addr(PtS^[0]);
         // Move(const Source; var Dest; Count: Integer);
         Move(PtS^,  PtT^,  CCount);
         Inc(SRow);
       end;
    except
        MessageDlg('PasteBitMapToBitMap : '
                 + '   BitMap  BitMap.',
                  mtWarning,
                  [mbOk], 0);
    end;
  end;
end;

// ------------------------------------------------------------------------
// 04.04.2014 ()
//  Image  
procedure ClearImage (RqImg : TImage; RqColor : TColor);
var WRect : TRect;
begin
  with RqImg, RqImg.Canvas do
  begin
     WRect := Rect(Left, Top, Left + Width, Top + Height);
     Pen.Color   := RqColor;
     Brush.Color := RqColor;
     Brush.Style := bsSolid;
     Rectangle(WRect);
  end;
end;

// ========================================================================
//
// ========================================================================
// 24.04.2014
//  SrcBitmap  TrgBitMap  
procedure BitMapToGrayBitMap(SrcBitmap : TBitmap;
                             TrgBitMap : TBitmap);
type  TBGR = record
        B : byte;
        G : byte;
        R : byte;
end;
type TArrBGR   = array[0..65535] of TBGR;
     ptTArrBGR = ^TArrBGR;

var   LC           : extended;     //    Light
      Row, Col     : word;         //     BitMap
      PtSrc, ptTrg : ptTArrBGR;    //     BitMap
      WBGR         : TBGR;         //    
      WL           : integer;      //   Light
begin
  //  
  if Assigned(SrcBitmap) and Assigned(TrgBitMap)
  then begin
     //  
     if (SrcBitmap.Width  > 0) and
        (SrcBitmap.Height > 0) and
        (SrcBitmap.PixelFormat = pf24bit)
     then begin
        LC  := Sqrt(3);   //    Light
        try
          if SrcBitmap <> TrgBitMap
          then begin
            TrgBitMap.Width  := SrcBitmap.Width;
            TrgBitMap.Height := SrcBitmap.Height;
            TrgBitMap.PixelFormat := pf24bit;
          end;
          //    SrcBitmap
          for Row := 0 to SrcBitmap.Height - 1 do
          begin
             //       SrcBitmap  TrgBitMap
             PtSrc := SrcBitmap.ScanLine[Row];
             ptTrg := TrgBitMap.ScanLine[Row];
             for Col := 0 to SrcBitmap.Width - 1 do
             begin
                WBGR := PtSrc^[Col];
                //    Light
                with WBGR do
                begin
                   WL := Round(Sqrt(B*B + G*G + R*R)/LC);
                   if WL > 255 then WL := 255;
                   B := WL; G := WL; R := WL;
                end;
                ptTrg^[Col] := WBGR;
             end;
          end;
       except
          MessageDlg('BitMapToGrayBitMap :    BitMap.',
                      mtWarning, [mbOk], 0);
       end;
     end;
  end;  // of Assigned
end;  // of procedure


// ========================================================================
//               END OF IMPLEMENTATION
// ========================================================================
end.
